/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialStoreAccessException;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.sas.LocalCredentialStore;
import com.ibm.hwmca.base.rsf.sas.UnsupportedTargetException;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PICredentials
implements CredentialStore,
BaseRsfRequestErrorIds {
    private static final String TRACE_MASKT = "XRSFCR T";
    private static final String TRACE_MASKF = "XRSFCR F";
    private static final String TRACE_MASKD = "XRSFCR D";
    private static String piStoreName = "com.ibm.hsc.remotesupport.credentials.RsfCredentialStore";
    private static CredentialStore store = new PICredentials();
    private static CredentialStore piStore = PICredentials.getPIStore();
    private static LocalCredentialStore cache = LocalCredentialStore.getCredentialStore();
    static /* synthetic */ Class class$com$ibm$hwmca$base$rsf$sas$CredentialStore;

    private PICredentials() {
    }

    public static CredentialStore getCredentialStore() {
        return store;
    }

    public SysInfo getCredential(Object target) throws UnsupportedTargetException, CredentialStoreAccessException {
        Trace.trace(TRACE_MASKT, "-> PICredentials::getCredential() for " + target);
        if (!(target instanceof String) || ((String)target).length() < 11) {
            throw new UnsupportedTargetException();
        }
        SysInfo cachedCredential = cache.getCredential(target);
        if (piStore == null) {
            Trace.trace(TRACE_MASKF, "PICredentials: no PI store: going to cache");
            Trace.trace(TRACE_MASKF, "PiCredentials: did we ever store credentials at machine?: " + cache.isCredentialStored((String)target));
            Trace.trace(TRACE_MASKT, "<-PICredentials::getCredential(): cached credential");
            return cachedCredential;
        }
        SysInfo piCredential = null;
        try {
            piCredential = piStore.getCredential(target);
        }
        catch (Exception e) {
            CredentialUtils.logInfo("PICredentials.getCredential - exception going to PI credential store", e, (short)12549);
        }
        if (piCredential == null) {
            Trace.trace(TRACE_MASKT, "<-PICredentials::getCredential(): cached credential");
            if (cachedCredential != null && !cache.isCredentialStored((String)target)) {
                try {
                    piStore.storeCredential(target, cachedCredential);
                    cache.setCredentialStored((String)target, true);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "PICredentials.storeCredential - exception going to PI credential store: " + e.getMessage());
                    cache.setCredentialStored((String)target, false);
                }
            }
            return cachedCredential;
        }
        if (piCredential.getMachineId() == null || piCredential.getPassword() == null || piCredential.getMachineId().trim().length() == 0 || piCredential.getPassword().trim().length() == 0) {
            if (cachedCredential != null) {
                if (!cache.isCredentialStored((String)target)) {
                    try {
                        piStore.storeCredential(target, cachedCredential);
                        cache.setCredentialStored((String)target, true);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "PICredentials.storeCredential - exception going to PI credential store: " + e.getMessage());
                        cache.setCredentialStored((String)target, false);
                    }
                }
                CredentialUtils.logInfo("PICredential: credential in cache but not at machine", null, (short)12549);
                Trace.trace(TRACE_MASKT, "<-PICredentials::getCredential(): cached credential");
                return cachedCredential;
            }
            CredentialResult result = CredentialUtils.getNewCredentialsSynchronous(target, piStore);
            Trace.trace(TRACE_MASKT, "<-PICredentials::getCredential() new credential");
            return result.getCredentials();
        }
        Trace.trace(TRACE_MASKT, "<-PICredentials::getCredential() machine stored credential");
        return piCredential;
    }

    public void storeCredential(Object target, SysInfo credential) throws UnsupportedTargetException, CredentialStoreAccessException {
        Trace.trace(TRACE_MASKT, "-> PICredentials::storeCredential() for " + target);
        if (!(target instanceof String) || ((String)target).length() < 11) {
            throw new UnsupportedTargetException();
        }
        if (piStore == null) {
            CredentialUtils.logInfo("PICredentials.storeCredential - no PI credential store: storing in cache", null, (short)12549);
            cache.storeCredential(target, credential);
            Trace.trace(TRACE_MASKT, "<- PICredentials::storeCredential() at cache only");
            cache.setCredentialStored((String)target, false);
            return;
        }
        cache.storeCredential(target, credential);
        try {
            piStore.storeCredential(target, credential);
            cache.setCredentialStored((String)target, true);
        }
        catch (Exception e) {
            cache.setCredentialStored((String)target, false);
            CredentialUtils.logInfo("PICredentials.storeCredential - exception going to PI credential store", e, (short)12549);
        }
        Trace.trace(TRACE_MASKT, "<- PICredentials::storeCredential()");
    }

    private static CredentialStore getPIStore() {
        Trace.trace(TRACE_MASKT, "<-PICredentials::getPIStore()");
        Class<?> implClass = null;
        try {
            implClass = Class.forName(piStoreName);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- PICredentials.getPIStore() returning null, implementation class not found for " + piStoreName);
            return null;
        }
        Class[] noargs = new Class[]{};
        Method factory = null;
        try {
            factory = implClass.getDeclaredMethod("getCredentialStore", noargs);
        }
        catch (NoSuchMethodException e) {
            Trace.trace(TRACE_MASKT, "<- PICredentials.getPIStore() returning null, no 'getCredentialStore()' method found in impl class for " + piStoreName);
            return null;
        }
        int mod = factory.getModifiers();
        if (factory.getReturnType() != (class$com$ibm$hwmca$base$rsf$sas$CredentialStore == null ? (class$com$ibm$hwmca$base$rsf$sas$CredentialStore = PICredentials.class$("com.ibm.hwmca.base.rsf.sas.CredentialStore")) : class$com$ibm$hwmca$base$rsf$sas$CredentialStore) || !Modifier.isPublic(mod) || !Modifier.isStatic(mod)) {
            Trace.trace(TRACE_MASKT, "<- PICredentials.getPIStore() returning null, return type or modifiers for 'getCredentialStore()' are wrong for " + piStoreName);
            return null;
        }
        CredentialStore storeImpl = null;
        try {
            storeImpl = (CredentialStore)factory.invoke(null, null);
            Trace.trace(TRACE_MASKT, "<- PICredentials.getPIStore() Ok for " + piStoreName);
            return storeImpl;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<- PICredentials.getPIStore() returning null, invocation of factory method threw an exception for " + piStoreName);
            Trace.trace(TRACE_MASKT, e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

